﻿using System;
using System.Collections.Generic;
using System.Data.Linq;
using System.Linq;
using System.Text;
using System.Web;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessAHOBPR;
using System.Reflection;

namespace VeteransAffairs.Registries.BusinessManagerAHOBPR
{
    public class AHOBPRUserManager : AHOBPRBaseBO
    {
        private AHOBPRShared _sharedManager = new AHOBPRShared();

        /// <summary>
        /// 
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public DBO_USER GetDboUser(int id)
        {
            DBO_USER user = null;
            using (_dbAhobpr = GetDataContext())
            {
                {
                    user = (from u in _dbAhobpr.DBO_USERs
                            where u.USER_ID == id
                            select u).FirstOrDefault();
                }
                return user;
            }
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public AHOBPR_USER GetUser(int id)
        {
            AHOBPR_USER user = null;
            using (_dbAhobpr = GetDataContext())
            {
                {
                    user = (from u in _dbAhobpr.AHOBPR_USERs
                            where u.USER_ID == id
                            select u).FirstOrDefault();
                }
                return user;
            }
        }

        //private void SetLoadWithForUser(AHOBPRDataAccess db)
        //{
        //    DataLoadOptions lo = new DataLoadOptions();
        //    //lo.LoadWith<AHOBPR_MAIN_USER>(e => e.);
        //    //lo.LoadWith<USER>(e => e.USER_RE);

        //    db.LoadOptions = lo;
        //    db.DeferredLoadingEnabled = false;

        //}

        /// <summary>
        /// 
        /// </summary>
        /// <param name="userId"></param>
        /// <returns></returns>
        public bool UpdateLastVistaLogin(String userId)
        {
            try
            {
                UserAccountManager mainUser = new UserAccountManager(userId, "AHOBPR");
                AHOBPR_USER user = GetUser(mainUser.UserId);

                user.SetAsChangeTrackingRoot();
                user.ACTIVE_FLAG = true;
                user.PENDING_FLAG = false;
                user.LAST_LOGIN = DateTime.Now;
                user.LAST_VISTA_LOGIN = DateTime.Now;
                user.SetAsUpdateOnSubmit();
                UpdateUser(user);
                return true;
            }
            catch (Exception ex)
            {
                _sharedManager.LogErrorMessage("Vista Login Update Exception", this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name, ex.Message);

                return false;
            }
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="ahobprUser"></param>
        /// <returns></returns>
        public int UpdateUser(AHOBPR_USER ahobprUser)
        {
            int returnStatus = 0;

            if (ahobprUser != null)
            {
                using (_dbAhobpr = GetDataContext())
                {
                    _dbAhobpr.DeferredLoadingEnabled = false;

                    //this line traverses all entities, attaching all of them as appropriate to the data context.
                    ahobprUser.SynchroniseWithDataContext(_dbAhobpr);

                    //Check if any actual changes will occur
                    ChangeSet changeSet = _dbAhobpr.GetChangeSet();

                    if (changeSet.Updates.Count > 0)
                    {
                        //if changes present then submit changes
                        try
                        {
                            _dbAhobpr.SubmitChanges(ConflictMode.ContinueOnConflict);
                            returnStatus = 1;

                        }
                        catch (System.Data.SqlClient.SqlException ex)
                        {
                            _sharedManager.LogErrorMessage("Sql Exception", this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name, ex.Message);
                            returnStatus = -1;
                        }
                        catch (ChangeConflictException)
                        {
                            _dbAhobpr.ChangeConflicts.ResolveAll(RefreshMode.KeepChanges);

                            returnStatus = 1;
                        }
                        catch (Exception ex)
                        {
                            _sharedManager.LogErrorMessage("Database Update", this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name, ex.Message);
                            returnStatus = -1;
                        }
                    }
                }
            }
            return returnStatus;
        }
    }
}